﻿//////////////////////////////////////////////
// ImageView.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class Image ;
}

/// Includes ---------------------------------

// nkImages
#include "../Dll/DllDefines.h"

#include "ImageBase.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages
{
	class DLL_IMAGES_EXPORT ImageView final : public ImageBase
	{
		public :

			// Constructor, destructor
			ImageView () noexcept = delete ;
			ImageView (const Image& image) noexcept ;
			ImageView (const nkMemory::BufferView<unsigned char>& dataView) noexcept ;
			ImageView (const nkMemory::BufferView<unsigned char> dataView, unsigned int width, unsigned int height, unsigned int depth, PIXEL_FORMAT format, unsigned int pixelOrBlockByteSize = 0, unsigned int rowByteSize = 0, unsigned int sliceByteSize = 0) noexcept ;
			ImageView (const nkMemory::BufferView<unsigned char> dataView, unsigned int width, unsigned int height, unsigned int depth, unsigned int arraySize, unsigned int mips, PIXEL_FORMAT format, unsigned int pixelOrBlockByteSize = 0) noexcept ;
			ImageView (const ImageView& other) noexcept ;
			ImageView (const ImageView& other, unsigned int slice) noexcept ;
			ImageView (const ImageView& other, unsigned int slice, unsigned int mip) noexcept ;
			ImageView (ImageView&& other) noexcept ;
			virtual ~ImageView () ;

			// Data access
			virtual unsigned char* getDataPtr () const override ;
			virtual unsigned long long getDataByteSize () const override ;
			virtual nkMemory::BufferView<> getDataBuffer () const override ;
			virtual bool isView () const override ;

			// Operators
			ImageView& operator= (const ImageView& other) noexcept ;
			ImageView& operator= (ImageView&& other) noexcept ;

		private :

			// Attributes
			// View over the data, provided from outside
			nkMemory::BufferView<unsigned char> _dataView ;
	} ;
}